/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import com.telepathicgrunt.repurposedstructures.world.structures.AdvancedJigsawStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSAdvancedDistanceConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.PieceLimitedJigsawManager;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2919;
import net.minecraft.class_3443;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6834;

public class AdvancedDistanceJigsawStructure<C extends RSAdvancedDistanceConfig>
extends AdvancedJigsawStructure<C> {
    public AdvancedDistanceJigsawStructure(Codec<C> codec) {
        super(codec, AdvancedDistanceJigsawStructure::isDistanceFeatureChunk, AdvancedDistanceJigsawStructure::generateDistancePieces);
    }

    public AdvancedDistanceJigsawStructure(Codec<C> codec, Predicate<class_6834.class_6835<C>> locationCheckPredicate, Function<class_6834.class_6835<C>, Optional<class_6622<C>>> pieceCreationPredicate) {
        super(codec, locationCheckPredicate, pieceCreationPredicate);
    }

    protected static <CC extends RSAdvancedDistanceConfig> boolean isDistanceFeatureChunk(class_6834.class_6835<CC> context) {
        int zBlockPos;
        RSAdvancedDistanceConfig config = (RSAdvancedDistanceConfig)context.comp_310();
        int radius = config.distanceFromOrigin;
        int xBlockPos = context.comp_309().method_8326();
        return xBlockPos * xBlockPos + (zBlockPos = context.comp_309().method_8328()) * zBlockPos > radius * radius && AdvancedDistanceJigsawStructure.isAdvancedFeatureChunk(context);
    }

    public static <CC extends RSAdvancedDistanceConfig> Optional<class_6622<CC>> generateDistancePieces(class_6834.class_6835<CC> context) {
        int bottomClipOff;
        int topClipOff;
        class_2338.class_2339 blockpos = new class_2338.class_2339(context.comp_309().method_8326(), 0, context.comp_309().method_8328());
        RSAdvancedDistanceConfig config = (RSAdvancedDistanceConfig)context.comp_310();
        if (config.maxY - config.minY <= 0) {
            RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + ((class_5321)config.startPool.method_40230().get()).method_29177());
        }
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        int structureStartHeight = random.nextInt(config.maxY - config.minY) + config.minY;
        blockpos.method_10104(class_2350.field_11036, structureStartHeight);
        if (config.verticalRange.isEmpty()) {
            topClipOff = config.clipOutOfBoundsPieces ? config.maxY + 5 : Integer.MAX_VALUE;
            bottomClipOff = config.clipOutOfBoundsPieces ? config.minY - 5 : Integer.MIN_VALUE;
        } else {
            topClipOff = structureStartHeight + (Integer)config.verticalRange.get();
            bottomClipOff = structureStartHeight - (Integer)config.verticalRange.get();
        }
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, new class_3812(config.startPool, config.size), GeneralUtils.getCsfNameForConfig(config, context.comp_314()), (class_2338)blockpos, false, false, topClipOff, bottomClipOff, config.poolsThatIgnoreBoundaries, (structurePiecesBuilder, pieces) -> {
            Optional<class_3790> lowestPiece = pieces.stream().min(Comparator.comparingInt(p -> p.method_14935().method_35416()));
            int minY = lowestPiece.map(poolElementStructurePiece -> poolElementStructurePiece.method_14935().method_35416()).orElseGet(() -> ((class_2338.class_2339)blockpos).method_10264());
            if (minY < context.comp_306().method_33730()) {
                int newOffset = context.comp_306().method_33730() - minY;
                for (class_3443 piece : pieces) {
                    piece.method_14922(0, newOffset, 0);
                }
            }
        });
    }
}

